<?php
/**
 * The template for displaying search forms in Decode
 * @package Decode
 */
 
 ///http://www.sitepoint.com/add-advanced-search-wordpress-site/
?>
<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">

	<label>
		<span><?php _e( 'Search', 'ainia' ); ?>:</span>
		<input type="search" class="search-field" placeholder="<?php echo esc_attr_x( 'Search&hellip;', 'placeholder', 'ainia' ); ?>" value="<?php echo esc_attr( get_search_query() ); ?>" name="s" title="<?php echo esc_attr_x( 'Search for:', 'label', 'ainia' ); ?>">
	</label>
	<br class="force"/>
	
	<label>
		<span><?php _e( 'Category', 'ainia' ); ?>:</span>
		<select name="category_name">	
			<option value="">-</option>
			<?php foreach (get_categories() as $category) 
				  echo '<option value="', $category->slug, '">', $category->name, "</option>\n"; ?>
		</select>
	</label>
	<br/>
	
	<label>
		<span><?php _e( 'Tag', 'ainia' ); ?>:</span>
		<select name="tag">	
			<option value="">-</option>
			<?php foreach (get_tags() as $tag) 
				  echo '<option value="', $tag->slug, '">', $tag->name, "</option>\n"; ?>
		</select>
	</label>
	<br/>
	
	<label>
		<span><?php _e( 'Source', 'ainia' ); ?>:</span>
		<select name="fuente">	
			<option value="">-</option>
			<?php foreach (get_terms("fuente") as $tag) 
				  echo '<option value="', $tag->slug, '">', $tag->name, "</option>\n"; ?>
		</select>
	</label>
	<br/>
	
	<label>
		<span><?php _e( 'Project', 'ainia' ); ?>:</span>
		<select name="proyecto">	
			<option value="">-</option>
			<?php foreach (get_terms("proyecto") as $tag) 
				  echo '<option value="', $tag->slug, '">', $tag->name, "</option>\n"; ?>
		</select>
	</label>
	<br/>
	
	
 
	<input type="submit" class="search-submit" value="<?php _e( 'Search', 'ainia' ); ?>">
	<br/><br class="clear"/>
</form>

